#include "GetPoint.js"

function DoPolygonEdge()
{
	var polygonfactory = moi.command.createFactory( 'polygonedge' );

	var ui = moi.ui;
	ui.bindUIToInput( 'numsidesinput', 'value', polygonfactory.getInput(2) );
	ui.bindUIToInput( 'flip', 'value', polygonfactory.getInput(3) );

	var pointpicker = ui.createPointPicker();

	if ( !GetPoint( pointpicker ) )
		return;

	polygonfactory.setInput( 0, pointpicker.ptframe );

	ui.beginUIUpdate();
	ui.hideUI( 'FirstPrompt' );
	ui.showUI( 'SecondPrompt' );
	ui.endUIUpdate();

	pointpicker.restrictToPlaneThroughPt( pointpicker.pt, true );
	pointpicker.disableVerticalStraightSnap = true;

	pointpicker.bindResultPt( polygonfactory.getInput(1) );
	pointpicker.bindResultOrientation( polygonfactory.getInput(0) );
	
	if ( !GetPoint( pointpicker ) )
		return;

	polygonfactory.commit();
}

DoPolygonEdge();
